Attribute VB_Name = "Module1"
Option Explicit

Global gCommand$, gOutState%, gOutText$, gFileIn$, gFileOut$, gh%

Rem Rem ABAP/4 data types      ANSI C         Visual Basic    Comment
Rem Const gTYPC     = 0       'RFC_CHAR       STRING $        characters
Rem Const gTYPDATE  = 1       'RFC_DATE       STRING $        date (YYYYMMDD)
Rem Const gTYPP     = 2       'RFC_BCD        STRING $        packed numbers
Rem Const gTYPTIME  = 3       'RFC_TIME       STRING $        time (HHMMSS)
Rem Const gTYPX     = 4       'RFC_BYTE       STRING $        raw data
Rem Const gTYPTABH  = 5       'not used here
Rem Const gTYPNUM   = 6       'RFC_NUM        STRING $        digits
Rem Const gTYPFLOAT = 7       'RFC_FLOAT      FLOAT #         floating point
Rem Const gTYPINT   = 8       'RFC_INT        LONG &          4 byte integer
Rem Const gTYPINT2  = 9       'RFC_INT2       INTEGER %       2 byte integer
Rem Const gTYPINT1  = 10      'RFC_INT1       INTEGER %       1 byte integer
Rem Const gTYPB     = 11      'not used here
Rem Const gTYP1     = 12      'not used here
Rem Const gTYP2     = 13      'not used here

Rem RFC_MODE Rfc open modus
Rem Const RFC_MODE_R3ONLY = 0 'only for R/3 systems, any kind of user
Rem Const RFC_MODE_CPIC   = 1 'can be used for R/2, but CPIC-Users only

Rem RFC_RC Rfc return codes
Const RFC_OK = 0            'OK
Rem Const RFC_FAILURE       = 1 'error occured
Rem Const RFC_EXCEPTION     = 2 'exception raised
Rem Const RFC_SYS_EXCEPTION = 3 'system exception raised, connection closed
Rem Const RFC_CALL          = 4 'call received
Rem Const RFC_INTERNAL_COM  = 5 'internal communication, repeat
Rem Const RFC_CLOSED        = 6 'connection closed by the other side
Const RFC_RETRY = 7         'no data yet (RfcListen only)
Rem Const RFC_NO_TID        = 8 'no transaction ID available
Rem Const RFC_EXECUTED      = 9 'function already executed

' struktierten Datentypen fr die RFC-Dll
Type RFC_ERROR_INFO
  Key     As String * 33
  status  As String * 128
  Message As String * 256
  intstat As String * 128
End Type

Type RFC_ERROR_INFO_EX
    RFC_ERROR_GROUP As Long
    Key As String * 33
    Message As String * 513
End Type

Type RFC_PARAMETER
  name As String
  nlen As Integer
  type As Integer
  leng As Integer
  addr As Long
End Type

Type RFC_TABLE
  name As String     'name of the table (in the interface definition of the function)
  nlen As Integer    'length of the name (should be len(name))
  type As Integer    'datatype of the lines of the table
  leng As Integer    'length of a row in bytes
  ithandle As Long   'table handle (type ITAB_H)
  itmode As Integer  'mode, how this table has to be received :  call by reference <-> call by value
  newitab As Integer 'table was created by RfcGetData
End Type

' Allgemeine RFC-Funtionen
Declare Function RfcOpenEx Lib "librfc32.dll" (ByVal Destination As String, _
    RfcError As RFC_ERROR_INFO_EX) As Long
Declare Sub RfcClose Lib "librfc32.dll" (ByVal hRfc As Long)
Declare Function RfcLastError Lib "librfc32.dll" (RfcErrorInfo As RFC_ERROR_INFO) As Long
Declare Function RfcLastErrorEx Lib "librfc32.dll" (RfcErrorInfo As RFC_ERROR_INFO_EX) As Long


' Client Funtionen
Declare Function RfcCallReceiveEx Lib "librfc32.dll" (ByVal hRfc As Long, _
    ByVal FunctionName As String, Exporting As RFC_PARAMETER, _
    Importing As RFC_PARAMETER, Importing As RFC_PARAMETER, _
    Tables As RFC_TABLE, ByRef Exception As String) As Long
Declare Function RfcReceiveEx Lib "librfc32.dll" (ByVal hRfc As Long, _
    ByVal FunctionName As String, Exporting As RFC_PARAMETER, _
    Importing As RFC_PARAMETER, Tables As RFC_TABLE) As Long

 
 


Rem Extended RFC functions
Declare Function RfcAllocParamSpace Lib "librfc32.dll" (ByVal numexp%, ByVal numimp%, ByVal numtab%) As Long
Declare Function RfcFreeParamSpace Lib "librfc32.dll" (ByVal hSpace&) As Integer
Declare Function RfcAddExportParam Lib "librfc32.dll" (ByVal hSpace&, ByVal parpos%, ByVal parname$, ByVal parnamelen%, ByVal partype%, ByVal parlen%, par As Any) As Integer
Declare Function RfcAddExportString Lib "librfc32.dll" Alias "RfcAddExportParam" (ByVal hSpace&, ByVal parpos%, ByVal parname$, ByVal parnamelen%, ByVal partype%, ByVal parlen%, ByVal par As String) As Integer
Declare Function RfcAddImportParam Lib "librfc32.dll" (ByVal hSpace&, ByVal parpos%, ByVal parname$, ByVal parnamelen%, ByVal partype%, ByVal parlen%, par As Any) As Integer
Declare Function RfcAddImportString Lib "librfc32.dll" Alias "RfcAddImportParam" (ByVal hSpace&, ByVal parpos%, ByVal parname$, ByVal parnamelen%, ByVal partype%, ByVal parlen%, ByVal par As String) As Integer
Declare Function RfcAddTable Lib "librfc32.dll" (ByVal hSpace&, ByVal tabpos%, ByVal tabname$, ByVal tabnamelen%, ByVal tabtype%, ByVal tablen%, ByVal tabhandle As Long) As Integer
Declare Function RfcCallExt Lib "librfc32.dll" (ByVal hRfc%, ByVal hSpace&, ByVal funcname$) As Integer
Declare Function RfcReceiveExt Lib "librfc32.dll" (ByVal hRfc%, ByVal hSpace&, ByVal Exception$) As Integer
Declare Function RfcCallReceiveExt Lib "librfc32.dll" (ByVal hRfc%, ByVal hSpace&, ByVal funcname$, ByVal Exception$) As Integer
Declare Function RfcAcceptExt Lib "librfc32.dll" (ByVal arguments As String) As Long

Declare Function RfcInstallFunction Lib "librfc32.dll" (ByVal funcname As String, ByVal funcpointer As Long, ByVal docu As String) As Long
Declare Function RfcInstallFunctionExt Lib "librfc32.dll" (ByVal hRfc As Long, ByVal funcname$, ByVal funcpointer&, ByVal docu$) As Long
Declare Function RfcWinInstallFunction Lib "librfc32.dll" (ByVal hRfc As Long, ByVal funcname$, ByVal funcpointer&, ByVal docu$) As Long
Declare Function RfcDispatch Lib "librfc32.dll" (ByVal hRfc As Long) As Long
Declare Function RfcListen Lib "librfc32.dll" (ByVal hRfc As Long) As Long

Declare Function RfcGetName Lib "librfc32.dll" (ByVal hRfc%, ByVal funcname$) As Integer
Declare Function RfcGetDataExt Lib "librfc32.dll" (ByVal hRfc%, ByVal hSpace&) As Integer
Declare Function RfcGetTableHandle Lib "librfc32.dll" (ByVal hSpace&, ByVal tableno%) As Long
Declare Function RfcSendDataExt Lib "librfc32.dll" (ByVal hRfc%, ByVal hSpace&) As Integer
Declare Function RfcRaise Lib "librfc32.dll" (ByVal hRfc%, ByVal Exception$) As Integer
Declare Function RfcAbort Lib "librfc32.dll" (ByVal hRfc%, ByVal text$)

Rem RFC_ITMODE RFC internal table mode
Rem Const RFC_ITMODE_BYREFERENCE = 0 'table is passed by reference
                                     '(ALLWAYS USE THIS)
Rem Const RFC_ITMODE_BYVALUE     = 1 'table is passed by value, changes are not transported back
                                     '(internal use only)
Rem Const RFC_ITMODE_KEEPALIVE   = 2 'table is passed by reference, but is kept alive after returning
                                     '(i.e. after RfcSendData, internal use only)



Rem general table functions
Declare Function ItCreate Lib "librfc32.dll" (ByVal ItName$, ByVal ItRecLen%, ByVal ItOccurs%, ByVal mem%) As Long
Declare Function ItDelete Lib "librfc32.dll" (ByVal hIt&) As Integer
Declare Function ItGetLine Lib "librfc32.dll" (ByVal hIt&, ByVal ItLine%) As Long
Declare Function ItInsLine Lib "librfc32.dll" (ByVal hIt&, ByVal ItLine%) As Long
Declare Function ItAppLine Lib "librfc32.dll" (ByVal hIt&) As Long
Declare Function ItDelLine Lib "librfc32.dll" (ByVal hIt&, ByVal ItLine%) As Integer
Declare Function ItGupLine Lib "librfc32.dll" (ByVal hIt&, ByVal ItLine%) As Long
Declare Function ItCpyLine Lib "librfc32.dll" (ByVal hIt&, ByVal ItLine%, ByVal dest As Long) As Integer
Declare Function ItFree Lib "librfc32.dll" (ByVal hIt&) As Integer
Declare Function ItFill Lib "librfc32.dll" (ByVal hIt&) As Integer
Declare Function ItLeng Lib "librfc32.dll" (ByVal hIt&) As Integer

Rem kernel functions
Declare Function lockWindowUpdate Lib "user" (ByVal hWnd As Integer) As Integer
Declare Sub hmemcpy Lib "kernel" (hpvDest As Any, hpvSource As Any, cbCopy As Integer)
Declare Sub structToPointer Lib "kernel" Alias "hmemcpy" (ByVal hpvDest As Any, hpvSource As Any, ByVal cbCopy As Long)
Declare Sub pointerToStruct Lib "kernel" Alias "hmemcpy" (hpvDest As Any, ByVal hpvSource As Any, ByVal cbCopy As Long)


